/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.planning.mokos;

import com.google.common.collect.Lists;
import cz.insophy.inplan.planning.mokos.FakeSet;
import cz.insophy.inplan.planning.mokos.MinimalTimeBound;
import cz.insophy.inplan.planning.mokos.Operation;
import cz.insophy.inplan.planning.mokos.Processor;
import cz.insophy.inplan.util.Tuple;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinBoundUpdater
extends Processor {
    private static final Logger log = LoggerFactory.getLogger(MinBoundUpdater.class);
    protected List<Operation> planneableOps = Lists.newArrayList();
    protected Set<Operation> planneableOpsView = new FakeSet<Operation>(this.planneableOps);
    protected long lastMinTime = Long.MIN_VALUE;

    @Override
    public void setSuccessors(List<Processor> successors) {
        super.setSuccessors(successors);
        this.checkOneSuccessor();
    }

    @Override
    public Tuple<Processor, Set<Operation>> process(Set<Operation> ops) {
        long minTime = Long.MAX_VALUE;
        for (Operation op : ops) {
            MinimalTimeBound.BoundDefinition boundDef = op.getBound();
            if (boundDef.getTime() > minTime) continue;
            if (boundDef.getTime() < minTime) {
                this.planneableOps.clear();
                minTime = boundDef.getTime();
            }
            this.planneableOps.add(op);
        }
        if (minTime == Long.MAX_VALUE) {
            this.planneableOps.clear();
            this.getScheduler().stopPlanning();
        } else {
            if (minTime < this.lastMinTime) {
                log.warn("MinTime is lower than the lastMinTime. Troubles may occur.");
                if (log.isDebugEnabled()) {
                    log.debug("Current minTime: {} {}", (Object)minTime, (Object)new Date(minTime));
                    log.debug("   Last minTime: {} {}", (Object)this.lastMinTime, (Object)new Date(this.lastMinTime));
                    for (Operation op : ops) {
                        if (op.getBound().getTime() >= this.lastMinTime) continue;
                        log.debug("Operation below last min time: {}, bounds:\n{}", (Object)op, (Object)op.getBounds());
                    }
                }
            }
            this.lastMinTime = minTime;
        }
        return Tuple.create(this.getDefaultSuccessor(), this.planneableOpsView);
    }
}

